package ThematicModelProto;
import java.util.HashMap;
import java.util.HashSet;

import org.w3c.dom.Document;
import org.w3c.dom.Element;


public class Natom implements Comparable<Natom>{
	
	String id;
	public String url;
	public String author;
	public HashSet<String> features = new HashSet<String>();
	
	public Double thematicScore=null;
	public Double componentScore=null;
	public Double score=null;

	//0 is focus 1 is match
	public HashMap<String, double[]> motifsmatch=new HashMap<String, double[]>();
	public HashMap<String, double[]> themesmatch=new HashMap<String, double[]>();
	public HashMap<String, double[]> componentsmatch=new HashMap<String, double[]>();
	
	public Natom(String id, String url, HashSet<String> features){
		this(id,url,features, "");
	}
	
	public Natom(String id, String url, HashSet<String> features, String author){
		this.id=id;
		this.url=url;
		this.features=features;
		this.author=author;

	}
	
	public HashSet<String> getFeatures(){
		return features;
	}
	
	public String getURL(){
		return this.url;
	}
	
	public Element toXML(Document doc){
		Element natom = doc.createElement("natom");
		
		Element idEl = doc.createElement("id");
		idEl.appendChild(doc.createTextNode(id));
		natom.appendChild(idEl);
		
		Element urlEl = doc.createElement("url");
		urlEl.appendChild(doc.createTextNode(url));
		natom.appendChild( urlEl );
		
		Element authorEl = doc.createElement("author");
		authorEl.appendChild(doc.createTextNode(author));
		natom.appendChild( authorEl );
		
		Element tagsEl = doc.createElement("tags");
		natom.appendChild( tagsEl );
		
		for(String feature:this.features){
			String tagS = feature;
			Element tag = doc.createElement("tag");
			tag.appendChild(doc.createTextNode(tagS));
			tagsEl.appendChild(tag);
		}	

		Element metricsEl = doc.createElement("metrics");

		if(this.componentScore != null){
			Element componentCoverage= doc.createElement("componentCoverage");
			componentCoverage.appendChild(doc.createTextNode(this.componentScore.toString()));
			metricsEl.appendChild(componentCoverage);
		}
		if(this.thematicScore != null){
			Element thematicCoverage= doc.createElement("thematicCoverage");
			thematicCoverage.appendChild(doc.createTextNode(this.thematicScore.toString()));
			metricsEl.appendChild(thematicCoverage);
		}
		if(this.score != null){
			Element averageCoverage= doc.createElement("averageCoverage");
			averageCoverage.appendChild(doc.createTextNode(this.score.toString()));
			metricsEl.appendChild(averageCoverage);
		}
		if(metricsEl.hasChildNodes()){
			natom.appendChild( metricsEl );
		}
		
		return natom;
	}

	public int compareTo(Natom otherNatom) {
		return (int)(otherNatom.score - this.score );
	}
	
}